/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Transform;

public class Plotarea
implements Serializable {
    Gc gc = new Gc(Color.white, null);
    double urX = 0.8;
    double urY = 0.8;
    double llX = 0.2;
    double llY = 0.2;
    boolean useDisplayList = true;
    Globals globals;
    private int gWidth = 640;
    private int gHeight = 480;
    Transform transform = new Transform(0.0, 0.0, 1.0, 1.0, 0, 0, this.gWidth, this.gHeight);

    public Plotarea() {
    }

    public Plotarea(Globals globals) {
        this.gc.globals = this.globals = globals;
    }

    public synchronized void draw(Graphics graphics) {
        if (this.globals.threeD) {
            this.draw3d(graphics);
        } else {
            this.gc.fillRect(graphics, this.transform.point(this.llX, this.llY), this.transform.point(this.urX, this.urY));
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this, this.transform.point(this.llX, this.llY), this.transform.point(this.urX, this.urY));
        }
    }

    public synchronized void draw3d(Graphics graphics) {
        Point[] pointArray = new Point[4];
        if (graphics == null) {
            return;
        }
        pointArray[0] = this.transform.point(this.llX, this.llY);
        pointArray[1] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        pointArray[2] = this.transform.point(this.urX, this.urY);
        pointArray[3] = new Point(pointArray[2].x + this.globals.xOffset, pointArray[2].y + this.globals.yOffset);
        this.gc.fillRect(graphics, pointArray[1], pointArray[3]);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this, pointArray[1], pointArray[3]);
        }
        Color color = this.gc.fillColor;
        this.gc.fillColor = color.darker();
        int n = pointArray[2].x;
        int n2 = pointArray[2].y;
        pointArray[2].x = pointArray[1].x;
        pointArray[2].y = pointArray[3].y;
        pointArray[3].x = pointArray[0].x;
        pointArray[3].y = n2;
        this.gc.drawPolygon(graphics, pointArray);
        pointArray[2].x = n + this.globals.xOffset;
        pointArray[2].y = pointArray[1].y;
        pointArray[3].x = n;
        pointArray[3].y = pointArray[0].y;
        this.gc.drawPolygon(graphics, pointArray);
        this.gc.fillColor = color;
    }

    public Gc getGc() {
        return this.gc;
    }

    public double getLlX() {
        return this.llX;
    }

    public double getLlY() {
        return this.llY;
    }

    public double getUrX() {
        return this.urX;
    }

    public double getUrY() {
        return this.urY;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public synchronized void resize(int n, int n2) {
        this.gWidth = n;
        this.gHeight = n2;
        this.transform = new Transform(0.0, 0.0, 1.0, 1.0, 0, 0, this.gWidth, this.gHeight);
    }

    public void setGc(Gc gc) {
        this.gc = gc;
    }

    public void setLlX(double d) {
        this.llX = d;
    }

    public void setLlY(double d) {
        this.llY = d;
    }

    public void setUrX(double d) {
        this.urX = d;
    }

    public void setUrY(double d) {
        this.urY = d;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "urX " + this.urX + "urY " + this.urY + "llX " + this.llX + "llY " + this.llY + "]";
    }
}

