/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.LegendInterface;
import javachart.chart.Transform;

public class Legend
implements LegendInterface,
Serializable {
    protected Globals globals;
    protected Gc backgroundGc = new Gc(Color.white, null);
    protected Font labelFont = Gc.defaultFont;
    protected Color labelColor = Color.black;
    protected boolean verticalLayout = false;
    protected boolean backgroundVisible = true;
    protected double llX = 0.0;
    protected double llY = 0.0;
    protected double urX;
    protected double urY;
    protected double iconHeight = 0.05;
    protected double iconWidth = 0.07;
    protected double iconGap = 0.02;
    protected boolean useDisplayList = true;
    protected Dataset[] datasets;
    protected Transform transform;
    int gWidth = 640;
    int gHeight = 480;

    public Legend() {
    }

    public Legend(Dataset[] datasetArray, Globals globals) {
        this.backgroundGc.globals = globals;
        this.globals = globals;
        this.datasets = datasetArray;
    }

    protected int cellHeight() {
        return (int)((double)this.globals.maxY * (this.iconHeight + this.iconGap + this.iconGap));
    }

    protected int cellWidth(int n, FontMetrics fontMetrics) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = fontMetrics.stringWidth(this.datasets[n3].setName);
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2 + (int)((double)this.globals.maxX * (this.iconWidth + this.iconGap * 2.0));
    }

    protected synchronized int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected synchronized void doHorizontalIcons(Graphics graphics) {
        int n = this.datasetsInUse();
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = this.cellWidth(n, fontMetrics);
        int n3 = (int)(this.iconWidth * (double)this.gWidth);
        int n4 = (int)(this.iconHeight * (double)this.gHeight);
        int n5 = (int)(this.iconGap * (double)this.gWidth);
        Point point = this.transform.point(this.llX + this.iconGap, this.llY + this.iconGap);
        Point point2 = new Point(point.x + n3, point.y + n4);
        int n6 = point.x;
        int n7 = (this.globals.maxX - point.x + n5) / n2;
        if (n7 < 1) {
            n7 = 1;
        }
        int n8 = n / n7;
        if (n % n7 == 0) {
            --n8;
        }
        int n9 = n8 * this.cellHeight();
        point.translate(0, n9);
        point2.translate(0, n9);
        int n10 = 0;
        while (n10 < n) {
            if (point.x - n5 + n2 > this.globals.maxX) {
                point.x = n6;
                point2.x = n6 + n3;
                point.translate(0, -this.cellHeight());
                point2.translate(0, -this.cellHeight());
            }
            this.datasets[n10].gc.fillRect(graphics, point, point2);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.datasets[n10], point, point2);
            }
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point2.x + n5, point.y, this.datasets[n10].setName);
            point.translate(n2, 0);
            point2.translate(n2, 0);
            ++n10;
        }
    }

    protected synchronized void doVerticalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.datasetsInUse();
        int n2 = this.cellWidth(n, fontMetrics);
        int n3 = this.cellHeight();
        int n4 = (int)(this.iconWidth * (double)this.gWidth);
        int n5 = (int)(this.iconHeight * (double)this.gHeight);
        int cfr_ignored_0 = (int)(this.iconGap * (double)this.gWidth);
        Point point = this.transform.point(this.llX + this.iconGap, this.llY + this.iconGap);
        Point point2 = new Point(point.x + n4, point.y + n5);
        int n6 = point.y;
        new Point(point2.x - point.x, point2.y - point.y);
        int n7 = 0;
        while (n7 < n) {
            this.datasets[n7].gc.fillRect(graphics, point, point2);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.datasets[n7], point, point2);
            }
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point2.x + 2, point.y, this.datasets[n7].setName);
            point.translate(0, n3);
            point2.translate(0, n3);
            if (point2.y > this.globals.maxY) {
                point.y = n6;
                point2.y = point.y + n5;
                point.translate(n2, 0);
                point2.translate(n2, 0);
            }
            ++n7;
        }
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.transform == null) {
            this.resize(this.globals.maxX, this.globals.maxY);
        }
        this.recalculateSize(graphics);
        if (this.backgroundVisible) {
            Point point = this.transform.point(this.llX, this.llY);
            Point point2 = this.transform.point(this.urX, this.urY);
            if (this.backgroundGc.getOutlineFills()) {
                point2.translate(-1, 0);
                point.translate(0, 1);
            }
            this.backgroundGc.fillRect(graphics, point, point2);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this, point, point2);
            }
        }
        if (this.verticalLayout) {
            this.doVerticalIcons(graphics);
        } else {
            this.doHorizontalIcons(graphics);
        }
    }

    public Gc getBackgroundGc() {
        return this.backgroundGc;
    }

    public boolean getBackgroundVisible() {
        return this.backgroundVisible;
    }

    public double getIconGap() {
        return this.iconGap;
    }

    public double getIconHeight() {
        return this.iconHeight;
    }

    public double getIconWidth() {
        return this.iconWidth;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public double getLlX() {
        return this.llX;
    }

    public double getLlY() {
        return this.llY;
    }

    public double getUrX() {
        return this.urX;
    }

    public double getUrY() {
        return this.urY;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public boolean getVerticalLayout() {
        return this.verticalLayout;
    }

    public synchronized void recalculateSize(Graphics graphics) {
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.datasetsInUse();
        int n2 = this.cellWidth(n, fontMetrics);
        int n3 = this.cellHeight();
        int n4 = 0;
        int n5 = 0;
        if (this.verticalLayout) {
            int n6 = (int)((double)this.globals.maxY * (1.0 - this.llY));
            n4 = n6 / n3;
            if (n4 > n) {
                n4 = n;
            }
            if (n4 == 0) {
                n4 = 1;
            }
            n5 = n / n4;
            if (n % n4 != 0) {
                ++n5;
            }
        } else {
            int n7 = (int)((double)this.globals.maxX * (1.0 - this.llX));
            n5 = n7 / n2;
            if (n5 > n) {
                n5 = n;
            }
            if (n5 == 0) {
                n5 = 1;
            }
            n4 = n / n5;
            if (n % n5 != 0) {
                ++n4;
            }
        }
        if (n4 == 0) {
            n4 = 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        this.urX = this.llX + this.iconGap + (double)n5 * (double)n2 / (double)this.globals.maxX;
        this.urY = this.llY + this.iconGap + (double)n4 * (double)n3 / (double)this.globals.maxY;
    }

    public void resize(int n, int n2) {
        this.gWidth = n;
        this.gHeight = n2;
        this.transform = new Transform(0.0, 0.0, 1.0, 1.0, 0, 0, this.gWidth, this.gHeight);
    }

    public void setBackgroundGC(Gc gc) {
        this.backgroundGc = gc;
        gc.globals = this.globals;
    }

    public void setBackgroundVisible(boolean bl) {
        this.backgroundVisible = bl;
    }

    public void setIconGap(double d) {
        this.iconGap = d;
    }

    public void setIconHeight(double d) {
        this.iconHeight = d;
    }

    public void setIconWidth(double d) {
        this.iconWidth = d;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void setLlX(double d) {
        this.llX = d;
    }

    public void setLlY(double d) {
        this.llY = d;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public void setVerticalLayout(boolean bl) {
        this.verticalLayout = bl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "urX " + this.urX + "urY " + this.urY + "llX " + this.llX + "llY " + this.llY + "]";
    }
}

