/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.util.Vector;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Plotarea;

public class LabelAxis
extends Axis
implements AxisInterface {
    protected Vector labelList;

    public LabelAxis() {
    }

    public LabelAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, bl, plotarea);
    }

    public synchronized void addLabel(String string) {
        if (this.labelList == null) {
            this.labelList = new Vector();
        }
        this.labelList.addElement(string);
    }

    public void addLabels(String[] stringArray) {
        this.replaceLabels(stringArray);
    }

    public synchronized void deleteLabel(int n) {
        if (this.labelList == null) {
            return;
        }
        this.labelList.removeElementAt(n);
    }

    protected String getLabel(double d, int n) {
        if (this.labelList != null && this.labelList.size() > n) {
            return (String)this.labelList.elementAt(n);
        }
        try {
            if (((Datum)this.datasets[0].data.elementAt((int)n)).label != null) {
                return ((Datum)this.datasets[0].data.elementAt((int)n)).label;
            }
            return super.getLabel(((Datum)this.datasets[0].data.elementAt((int)n)).y, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return " ";
        }
    }

    private synchronized boolean labelScale() {
        int n = 0;
        int n2 = this.datasetsInUse();
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (n < this.datasets[n3].data.size()) {
                n = this.datasets[n3].data.size();
            }
            ++n3;
        }
        this.axisStart = 0.0;
        if (this.userAxisStart != null) {
            this.axisStart = this.userAxisStart;
        }
        if (this.userAxisEnd != null) {
            n = this.userAxisEnd.intValue();
        }
        if (this.barScaling) {
            this.axisStart -= 1.0;
            this.axisEnd = n;
            this.numLabels = n;
            this.numMajTicks = this.numLabels + 1;
        } else {
            this.axisEnd = (double)n - 1.0;
            this.numMajTicks = this.numLabels = n - 1;
        }
        this.numGrids = this.numMajTicks;
        this.numMinTicks = this.numMajTicks * 2;
        return true;
    }

    public synchronized void replaceLabels(String[] stringArray) {
        this.labelList = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.labelList.addElement(stringArray[n]);
            ++n;
        }
    }

    public void scale() {
        this.labelScale();
    }

    public void setLogScaling(boolean bl) {
    }

    protected int whereOnAxis(int n, int n2) {
        if (n2 == 4 || n2 == 3 || n2 == 2) {
            return super.whereOnAxis(n, n2);
        }
        if (this.side == 0 || this.side == 2) {
            float f = this.getIncrement(this.endPoint.x, this.startPoint.x, this.numMajTicks);
            if (this.barScaling) {
                return this.startPoint.x + (int)(f * (float)(n + 1));
            }
            return this.startPoint.x + (int)(f * (float)n);
        }
        float f = this.getIncrement(this.endPoint.y, this.startPoint.y, this.numMajTicks);
        if (this.barScaling) {
            return this.startPoint.y + (int)(f * (float)(n + 1));
        }
        return this.startPoint.y + (int)(f * (float)n);
    }
}

