/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.Background;
import javachart.chart.Bar;
import javachart.chart.Chart;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Plotarea;

public class BarChart
extends Chart {
    Bar bar;

    public BarChart() {
    }

    public BarChart(String string) {
        super(string);
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        } else {
            this.xAxis.scale();
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        } else {
            this.yAxis.scale();
        }
        this.dataRepresentation.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public Bar getBar() {
        return this.bar;
    }

    protected void initAxes() {
        this.setXAxis(new LabelAxis());
        this.xAxis.setBarScaling(true);
        this.xAxis.setSide(0);
        this.setYAxis(new Axis());
        this.yAxis.setBarScaling(true);
    }

    protected void initChart() {
        this.initGlobals();
        this.setPlotarea(new Plotarea());
        this.setBackground(new Background());
        this.initDatasets();
        this.initAxes();
        this.bar = new Bar();
        this.setDataRepresentation(this.bar);
        this.setLegend(new Legend());
        this.resize(640, 480);
    }

    public void setBar(Bar bar) {
        this.bar = bar;
        this.setDataRepresentation(bar);
    }
}

