/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.DataRepresentation;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Bar
extends DataRepresentation {
    protected double clusterWidth = 0.8;
    protected double baseline = 0.0;
    protected double observationDelta = 1.0;
    protected boolean unitScaling = true;
    boolean doClip = false;
    double xAxisStart;
    double xAxisEnd;
    double yAxisStart;
    double yAxisEnd;
    protected Transform dataXfm;
    protected boolean useValueLabels = false;

    public Bar() {
    }

    public Bar(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.xAxis = axisInterface;
        this.yAxis = axisInterface2;
        this.plotarea = plotarea;
        this.globals = this.plotarea.globals;
    }

    protected void buildDataXfm() {
        this.xAxisStart = this.xAxis.getAxisStart();
        this.xAxisEnd = this.xAxis.getAxisEnd();
        this.yAxisStart = this.yAxis.getAxisStart();
        this.yAxisEnd = this.yAxis.getAxisEnd();
        this.dataXfm = new Transform(this.xAxisStart, this.yAxisStart, this.xAxisEnd, this.yAxisEnd, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
        this.dataXfm.logXScaling = this.xAxis.getLogScaling();
        this.dataXfm.logYScaling = this.yAxis.getLogScaling();
    }

    protected int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected void doBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2;
        double d3 = 0.5 * this.observationDelta * this.clusterWidth;
        Datum datum = this.datasets[n].getDataElementAt(n2);
        double d4 = this.unitScaling ? (double)n2 - d3 + d * (double)n : datum.x - d3 + d * this.observationDelta * (double)n;
        double d5 = d4 + d * this.observationDelta;
        try {
            d2 = datum.y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (datum.label == "D") {
            return;
        }
        double d6 = this.baseline;
        Point point = this.dataXfm.point(d4, d6);
        Point point2 = this.dataXfm.point(d5, d2);
        if (point2.x - point.x < 1) {
            point2.translate(1, 0);
        }
        if (!bl) {
            this.datasets[n].gc.fillRect(graphics, point, point2);
        } else {
            datum.gc.fillRect(graphics, point, point2);
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            if (bl) {
                this.globals.displayList.addRectangle(datum, point, point2);
                this.globals.displayList.addRectangle(this.datasets[n], point, point2);
            } else {
                this.globals.displayList.addRectangle(this.datasets[n], point, point2);
                this.globals.displayList.addRectangle(datum, point, point2);
            }
            this.globals.displayList.addRectangle(this, point, point2);
        }
    }

    protected void doBarLabel(Graphics graphics, double d, int n, int n2) {
        double d2 = 0.5 * this.observationDelta * this.clusterWidth;
        Datum datum = this.datasets[n].getDataElementAt(n2);
        double d3 = this.unitScaling ? (double)n2 - d2 + d * (double)n : datum.x - d2 + d * this.observationDelta * (double)n;
        double d4 = d3 + d * this.observationDelta;
        double d5 = datum.y;
        String string = datum.label != null && !this.useValueLabels ? datum.label : this.formatLabel(datum.y);
        graphics.setFont(this.datasets[n].labelFont);
        graphics.setColor(this.datasets[n].labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = this.dataXfm.point(d3 + (d4 - d3) / 2.0, d5);
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y + 2, 2, this.labelAngle, fontMetrics, string);
    }

    protected void doBars(Graphics graphics, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = this.datasetsInUse();
        int n4 = 0;
        while (n4 < n3) {
            if (n2 < this.datasets[n4].data.size()) {
                n2 = this.datasets[n4].data.size();
            }
            ++n4;
        }
        double d = this.clusterWidth / (double)n3;
        if (this.unitScaling) {
            this.observationDelta = 1.0;
        } else if (this.datasets[0] != null) {
            try {
                this.observationDelta = this.datasets[0].getDataElementAt((int)1).x - this.datasets[0].getDataElementAt((int)0).x;
            }
            catch (Exception exception) {
                this.observationDelta = 1.0;
            }
        }
        if (!this.globals.threeD) {
            n4 = 0;
            while (n4 < n3) {
                n = 0;
                while (n < this.datasets[n4].data.size()) {
                    this.doBar(graphics, d, n4, n, bl);
                    ++n;
                }
                ++n4;
            }
        } else {
            n = 0;
            while (n < n2) {
                n4 = 0;
                while (n4 < n3) {
                    this.doDBar(graphics, d, n4, n, bl);
                    ++n4;
                }
                ++n;
            }
        }
        if (this.labelsOn) {
            n4 = 0;
            while (n4 < n3) {
                n = 0;
                while (n < this.datasets[n4].data.size()) {
                    this.doBarLabel(graphics, d, n4, n);
                    ++n;
                }
                ++n4;
            }
        }
    }

    protected void doDBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        Gc gc;
        double d2;
        double d3 = 0.5 * this.observationDelta * this.clusterWidth;
        Point[] pointArray = new Point[4];
        Datum datum = this.datasets[n].getDataElementAt(n2);
        double d4 = this.unitScaling ? (double)n2 - d3 + d * (double)n : datum.x - d3 + d * this.observationDelta * (double)n;
        double d5 = d4 + d * this.observationDelta;
        try {
            d2 = datum.y;
        }
        catch (Exception exception) {
            return;
        }
        double d6 = this.baseline;
        pointArray[0] = this.dataXfm.point(d4, d6);
        pointArray[1] = this.dataXfm.point(d5, d2);
        try {
            gc = !bl ? this.datasets[n].gc : datum.gc;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            gc = this.datasets[n].gc;
        }
        gc.fillRect(graphics, pointArray[0], pointArray[1]);
        if (this.useDisplayList && this.globals.useDisplayList) {
            if (bl) {
                this.globals.displayList.addRectangle(datum, pointArray[0], pointArray[1]);
                this.globals.displayList.addRectangle(this.datasets[n], pointArray[0], pointArray[1]);
            } else {
                this.globals.displayList.addRectangle(this.datasets[n], pointArray[0], pointArray[1]);
                this.globals.displayList.addRectangle(datum, pointArray[0], pointArray[1]);
            }
            this.globals.displayList.addRectangle(this, this.dataXfm.point(d4, d6), this.dataXfm.point(d5, d2));
        }
        Color color = gc.fillColor;
        gc.fillColor = color.darker();
        pointArray[0] = this.dataXfm.point(d5, d6);
        pointArray[2] = new Point(pointArray[1].x + this.globals.xOffset, pointArray[1].y + this.globals.yOffset);
        pointArray[3] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        gc.drawPolygon(graphics, pointArray);
        if (d2 > d6) {
            pointArray[0] = this.dataXfm.point(d4, d2);
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        } else {
            pointArray[0] = this.dataXfm.point(d4, d6);
            pointArray[1] = this.dataXfm.point(d5, d6);
            pointArray[2].x = pointArray[1].x + this.globals.xOffset;
            pointArray[2].y = pointArray[1].y + this.globals.yOffset;
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        }
        gc.fillColor = color;
    }

    private void doDraw(Graphics graphics, boolean bl) {
        Graphics graphics2 = graphics;
        if (graphics == null) {
            return;
        }
        this.buildDataXfm();
        double d = this.baseline;
        if (this.yAxis.getLogScaling() && this.baseline <= 0.0) {
            this.baseline = Math.pow(10.0, this.yAxis.getAxisStart());
        }
        if (this.doClip) {
            graphics = graphics.create();
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        this.doBars(graphics, bl);
        this.baseline = d;
        graphics = graphics2;
    }

    public synchronized void draw(Graphics graphics) {
        this.doDraw(graphics, false);
    }

    public synchronized void drawInd(Graphics graphics) {
        this.doDraw(graphics, true);
    }

    protected synchronized void drawSet(Graphics graphics, int n, boolean bl) {
        int n2;
        if (!this.globals.threeD) {
            n2 = 0;
            while (n2 < this.datasets[n].data.size()) {
                this.doBar(graphics, this.clusterWidth, n, n2, bl);
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < this.datasets[n].data.size()) {
                this.doDBar(graphics, this.clusterWidth, n, n2, bl);
                ++n2;
            }
        }
        if (this.labelsOn) {
            n2 = 0;
            while (n2 < this.datasets[n].data.size()) {
                this.doBarLabel(graphics, this.clusterWidth, n, n2);
                ++n2;
            }
        }
    }

    public double getBaseline() {
        return this.baseline;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public boolean getDoClip() {
        return this.doClip;
    }

    public boolean getUseValueLabels() {
        return this.useValueLabels;
    }

    public void setBaseline(double d) {
        this.baseline = d;
    }

    public void setClusterWidth(double d) {
        this.clusterWidth = d;
    }

    public void setDoClip(boolean bl) {
        this.doClip = bl;
    }

    public void setUseValueLabels(boolean bl) {
        this.useValueLabels = bl;
    }
}

