/*
 * Decompiled with CFR 0.152.
 */
package javachart.applet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.applet.GetParam;
import javachart.chart.AxisInterface;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;

public class ParameterParser {
    protected ChartInterface chart;
    protected GetParam getter;
    protected static String delimiter = ",";
    protected double[] yArr = new double[]{234.0, 543.0, 234.0, 654.0};
    boolean gotDatasets = false;
    protected URL myUrl;
    protected Format defaultNumberFormat = NumberFormat.getInstance();
    protected Format dataRepFormat = null;
    protected Format yAxisFormat = null;
    protected Format xAxisFormat = null;

    public ParameterParser(ChartInterface chartInterface, GetParam getParam) {
        this.chart = chartInterface;
        this.getter = getParam;
    }

    public boolean closeURL(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("can't close URL");
            return false;
        }
        return true;
    }

    public void getAxisOptions() {
        this.parseAxOptions("yAxis", this.chart.getYAxis());
        this.parseAxOptions("xAxis", this.chart.getXAxis());
        String string = this.getParameter("xAxisLabels");
        if (string != null) {
            this.getXAxisLabels(string);
        }
    }

    public void getAxisOptions(AxisInterface axisInterface, String string) {
        if (string.indexOf("logScaling") != -1) {
            axisInterface.setLogScaling(true);
        }
        if (string.indexOf("autoScale") != -1) {
            axisInterface.setAutoScale(true);
        }
        if (string.indexOf("noAutoScale") != -1) {
            axisInterface.setAutoScale(false);
        }
        if (string.indexOf("lineOn") != -1) {
            axisInterface.setLineVis(true);
        }
        if (string.indexOf("lineOff") != -1) {
            axisInterface.setLineVis(false);
        }
        if (string.indexOf("labelsOn") != -1) {
            axisInterface.setLabelVis(true);
        }
        if (string.indexOf("labelsOff") != -1) {
            axisInterface.setLabelVis(false);
        }
        if (string.indexOf("gridOn") != -1) {
            axisInterface.setGridVis(true);
        }
        if (string.indexOf("gridOff") != -1) {
            axisInterface.setGridVis(false);
        }
        if (string.indexOf("tickOn") != -1) {
            axisInterface.setMajTickVis(true);
        }
        if (string.indexOf("tickOff") != -1) {
            axisInterface.setMajTickVis(false);
        }
        if (string.indexOf("minTickOn") != -1) {
            axisInterface.setMinTickVis(true);
        }
        if (string.indexOf("minTickOff") != -1) {
            axisInterface.setMinTickVis(false);
        }
        if (string.indexOf("rightAxis") != -1) {
            axisInterface.setSide(3);
        }
        if (string.indexOf("leftAxis") != -1) {
            axisInterface.setSide(1);
        }
        if (string.indexOf("topAxis") != -1) {
            axisInterface.setSide(2);
        }
        if (string.indexOf("bottomAxis") != -1) {
            axisInterface.setSide(0);
        }
        if (string.indexOf("rotateTitle") != -1) {
            axisInterface.setTitleRotated(true);
        }
    }

    public Color getColor(String string) {
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("transparent")) {
            return Gc.TRANSPARENT;
        }
        try {
            return new Color(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public boolean getDataset(int n) {
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        Dataset dataset = this.getter.getDataset(this.chart, n);
        if (dataset != null) {
            this.chart.addDataset(dataset);
            this.getDatasetPropertiesFromParameters(n, dataset);
            return true;
        }
        String string = this.getParameter("dataset" + n + "xValues");
        if (string != null) {
            dArray = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "dateValues")) != null) {
            dArray = this.getDateVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "yValues")) != null) {
            dArray2 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y2Values")) != null) {
            dArray3 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y3Values")) != null) {
            dArray4 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "xyValues")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
            dArray = new double[stringTokenizer.countTokens() / 2];
            dArray2 = new double[dArray.length];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    dArray[n2] = Double.valueOf(stringTokenizer.nextToken().trim());
                    dArray2[n2] = Double.valueOf(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    dArray[n2] = Double.NEGATIVE_INFINITY;
                    dArray2[n2] = Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, dArray4);
    }

    public boolean getDatasetParameters(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        String[] stringArray = null;
        String string = this.getParameter("dataset" + n + "Name");
        String string2 = string != null ? string : new String("dataset" + n);
        string = this.getParameter("dataset" + n + "Labels");
        if (string != null) {
            stringArray = this.getLabels(string);
        }
        if ((string = this.getParameter("dataset" + n + "URLLabels")) != null) {
            InputStream inputStream = this.openURL(string);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                stringArray = this.getLabels(string);
            }
            this.closeURL(inputStream);
        }
        if (dArray4 != null && dArray3 != null && dArray2 != null) {
            this.chart.addDataset(string2, dArray, dArray2, dArray3, dArray4);
        } else if (dArray3 != null && dArray2 != null && stringArray != null) {
            if (dArray == null) {
                this.chart.addDataset(string2, dArray2, dArray3, stringArray);
            } else {
                this.chart.addDataset(string2, dArray, dArray2, stringArray);
            }
        } else if (dArray3 != null && dArray2 != null && stringArray == null) {
            if (dArray == null) {
                this.chart.addDataset(string2, dArray2, dArray3);
            } else {
                this.chart.addDataset(string2, dArray, dArray2);
            }
        } else if (dArray2 != null) {
            if (stringArray != null) {
                if (dArray == null) {
                    this.chart.addDataset(string2, dArray2, stringArray);
                } else {
                    this.chart.addDataset(string2, dArray, dArray2, stringArray);
                }
            } else if (dArray == null) {
                this.chart.addDataset(string2, dArray2);
            } else {
                this.chart.addDataset(string2, dArray, dArray2);
            }
        }
        if (dArray2 == null) {
            return false;
        }
        this.getDatasetPropertiesFromParameters(n, this.chart.getDatasets()[n]);
        return true;
    }

    public void getDatasetPropertiesFromParameters(int n, Dataset dataset) {
        String string = this.getParameter("dataset" + n + "Color");
        if (string != null) {
            dataset.getGc().setFillColor(this.getColor(string));
            dataset.getGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Name")) != null) {
            dataset.setName(string);
        } else {
            dataset.setName("dataset" + n);
        }
        string = this.getParameter("dataset" + n + "Colors");
        if (string != null) {
            String[] stringArray = this.getLabels(string);
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    dataset.getDataElementAt(n2).getGc().setFillColor(this.getColor(stringArray[n2]));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = stringArray.length;
                }
                ++n2;
            }
        }
        if ((string = this.getParameter("dataset" + n + "LineWidth")) != null) {
            dataset.getGc().setLineWidth(Integer.parseInt(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelFont")) != null) {
            dataset.setLabelFont(ParameterParser.getFont(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelColor")) != null) {
            dataset.setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Image")) != null) {
            dataset.getGc().setImage(this.makeURLImage(string));
        }
        if ((string = this.getParameter("dataset" + n + "MarkerStyle")) != null) {
            dataset.getGc().setMarkerStyle(Integer.parseInt(string));
        }
        if ((string = this.getParameter("dataset" + n + "MarkerSize")) != null) {
            dataset.getGc().setMarkerSize(Integer.parseInt(string));
        }
    }

    public void getDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getDataset(n)) {
            ++n;
        }
    }

    protected double[] getDateVals(String string) {
        return null;
    }

    public static Font getFont(String string) {
        int n = string.indexOf(delimiter, 0);
        String string2 = string.substring(0, n);
        int n2 = string.indexOf(delimiter, n + 1);
        int n3 = Integer.valueOf(string.substring(n + 1, n2));
        int n4 = Integer.valueOf(string.substring(n2 + 1));
        Font font = new Font(string2, n4, n3);
        if (font != null) {
            return font;
        }
        return Gc.defaultFont;
    }

    public String[] getLabels(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                stringArray[n] = stringTokenizer.nextToken().trim();
            }
            catch (Exception exception) {
                stringArray[n] = " ";
            }
            ++n;
        }
        return stringArray;
    }

    public synchronized String getLineFromURL(InputStream inputStream) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(256);
        while (true) {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                System.out.println("bad i/o operation");
                return null;
            }
            if (n == -1) {
                if (stringBuffer.length() == 0) {
                    return null;
                }
                return stringBuffer.toString();
            }
            if (n == 10 || n == 13) {
                if (stringBuffer.length() <= 0) continue;
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    public void getOptions() {
        String string = this.getParameter("delimiter");
        if (string != null) {
            delimiter = new String(string);
        }
        if ((string = this.getParameter("internalData")) != null && string.equalsIgnoreCase("true")) {
            this.getDatasets();
        }
        if ((string = this.getParameter("URLDataBlock")) != null) {
            this.getURLDataBlock(string);
        }
        if ((string = this.getParameter("URLXYDataRows")) != null) {
            this.getURLXYDataRows(string);
        }
        if ((string = this.getParameter("URLXYDataColumns")) != null) {
            this.getURLXYDataColumns(string);
        }
        if ((string = this.getParameter("dataset0xURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0yURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xyURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0yValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0xyValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("customDatasetHandler")) != null) {
            this.getter.getMyDatasets(string);
        }
        if ((string = this.getParameter("legendOn")) != null) {
            this.chart.setLegendVisible(true);
        }
        if ((string = this.getParameter("legendOff")) != null) {
            this.chart.setLegendVisible(false);
        }
        if ((string = this.getParameter("legendColor")) != null) {
            this.chart.getLegend().getBackgroundGc().setFillColor(this.getColor(string));
            this.chart.getLegend().getBackgroundGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendVertical")) != null) {
            this.chart.getLegend().setVerticalLayout(true);
        }
        if ((string = this.getParameter("legendHorizontal")) != null) {
            this.chart.getLegend().setVerticalLayout(false);
        }
        if ((string = this.getParameter("legendLabelColor")) != null) {
            this.chart.getLegend().setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendLabelFont")) != null) {
            this.chart.getLegend().setLabelFont(ParameterParser.getFont(string));
        }
        if ((string = this.getParameter("legendllX")) != null) {
            this.chart.getLegend().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("legendllY")) != null) {
            this.chart.getLegend().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("iconWidth")) != null) {
            this.chart.getLegend().setIconWidth(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconHeight")) != null) {
            this.chart.getLegend().setIconHeight(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconGap")) != null) {
            this.chart.getLegend().setIconGap(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("plotAreaTop")) != null) {
            this.chart.getPlotarea().setUrY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaBottom")) != null) {
            this.chart.getPlotarea().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaLeft")) != null) {
            this.chart.getPlotarea().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaRight")) != null) {
            this.chart.getPlotarea().setUrX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaColor")) != null) {
            this.chart.getPlotarea().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("backgroundImage")) != null) {
            this.chart.getBackground().getGc().setImage(this.makeURLImage(string));
        }
        if ((string = this.getParameter("backgroundColor")) != null) {
            this.chart.getBackground().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleColor")) != null) {
            this.chart.getBackground().setTitleColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleFont")) != null) {
            this.chart.getBackground().setTitleFont(ParameterParser.getFont(string));
        }
        if ((string = this.getParameter("titleString")) != null) {
            this.chart.getBackground().setTitleString(string);
        }
        if ((string = this.getParameter("subTitleColor")) != null) {
            this.chart.getBackground().setSubTitleColor(this.getColor(string));
        }
        if ((string = this.getParameter("subTitleFont")) != null) {
            this.chart.getBackground().setSubTitleFont(ParameterParser.getFont(string));
        }
        if ((string = this.getParameter("subTitleString")) != null) {
            this.chart.getBackground().setSubTitleString(string);
        }
        if ((string = this.getParameter("3D")) != null) {
            this.chart.setThreeD(true);
        }
        if ((string = this.getParameter("2D")) != null) {
            this.chart.setThreeD(false);
        }
        if ((string = this.getParameter("XDepth")) != null) {
            this.chart.setXOffset(Integer.parseInt(string));
        }
        if ((string = this.getParameter("YDepth")) != null) {
            this.chart.setYOffset(Integer.parseInt(string));
        }
        if ((string = this.getParameter("labelsOn")) != null) {
            this.chart.getDataRepresentation().setLabelsOn(true);
        }
        if ((string = this.getParameter("labelAngle")) != null) {
            this.chart.getDataRepresentation().setLabelAngle(Integer.parseInt(string));
        }
        if ((string = this.getParameter("labelFormat")) != null) {
            this.chart.getDataRepresentation().setLabelFormat(Integer.parseInt(string));
        }
        if ((string = this.getParameter("labelPrecision")) != null) {
            this.chart.getDataRepresentation().setLabelPrecision(Integer.parseInt(string));
        }
        this.getAxisOptions();
        if (this.chart.getNumDatasets() < 1) {
            this.chart.addDataset("dummy", this.yArr);
            this.chart.getBackground().setTitleString("Sample Data");
            this.chart.getBackground().setSubTitleString("(no data available)");
        }
        if ((string = this.getParameter("outlineColor")) != null) {
            Color color = this.getColor(string);
            Gc gc = this.chart.getPlotarea().getGc();
            gc.setOutlineFills(true);
            gc.setLineColor(color);
            gc = this.chart.getBackground().getGc();
            gc.setOutlineFills(true);
            gc.setLineColor(color);
            gc = this.chart.getLegend().getBackgroundGc();
            gc.setOutlineFills(true);
            gc.setLineColor(color);
            int n = 0;
            while (n < this.chart.getDatasets().length) {
                if (this.chart.getDatasets()[n] != null) {
                    gc = this.chart.getDatasets()[n].getGc();
                    gc.setOutlineFills(true);
                }
                ++n;
            }
        }
        if ((string = this.getParameter("outlineDataRepresentation")) != null && string.equalsIgnoreCase("false")) {
            int n = 0;
            while (n < this.chart.getDatasets().length) {
                if (this.chart.getDatasets()[n] != null) {
                    this.chart.getDatasets()[n].getGc().setOutlineFills(false);
                }
                ++n;
            }
        }
        if ((string = this.getParameter("outlinePlotarea")) != null && string.equalsIgnoreCase("false")) {
            this.chart.getPlotarea().getGc().setOutlineFills(false);
        }
        if ((string = this.getParameter("outlineBackground")) != null && string.equalsIgnoreCase("false")) {
            this.chart.getBackground().getGc().setOutlineFills(false);
        }
        if ((string = this.getParameter("outlineLegend")) != null && string.equalsIgnoreCase("false")) {
            this.chart.getLegend().getBackgroundGc().setOutlineFills(false);
        }
    }

    public String getParameter(String string) {
        return this.getter.getParameter(string);
    }

    protected boolean getURLDataBlock(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray2 = this.getVals(string2);
            this.getDatasetParameters(n, dArray, dArray2, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    protected boolean getURLDataset(int n) {
        int n2;
        String string;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        String string2 = this.getParameter("dataset" + n + "xURL");
        if (string2 != null && (inputStream = this.openURL(string2)) != null) {
            string = this.getLineFromURL(inputStream);
            dArray = this.getVals(string);
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("dataset" + n + "yURL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray2[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "y2URL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray3[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray3 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "xyURL")) != null) {
            System.out.println("xyVals not supported yet");
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, null);
    }

    protected void getURLDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getURLDataset(n)) {
            ++n;
        }
    }

    protected boolean getURLXYDataColumns(String string) {
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        String string2 = this.getLineFromURL(inputStream);
        int n = Integer.parseInt(string2.trim());
        double[][] dArray3 = new double[n][];
        dArray = new double[n];
        dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            string2 = this.getLineFromURL(inputStream);
            dArray3[n2] = this.getVals(string2);
            ++n2;
        }
        this.closeURL(inputStream);
        int n3 = dArray3[0].length;
        n2 = 0;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                try {
                    dArray[n4] = dArray3[n4][n2];
                    dArray2[n4] = dArray3[n4][n2 + 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in column " + n2 + " and row " + n4);
                    return false;
                }
                ++n4;
            }
            this.getDatasetParameters(n2 / 2, dArray, dArray2, null, null);
            n2 += 2;
        }
        return true;
    }

    protected boolean getURLXYDataRows(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray = this.getVals(string2);
            dArray2 = new double[dArray.length / 2];
            dArray3 = new double[dArray2.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < dArray.length) {
                try {
                    dArray2[n2] = dArray[n3];
                    dArray3[n2] = dArray[++n3];
                    ++n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in dataset " + n);
                    return false;
                }
                ++n3;
            }
            this.getDatasetParameters(n, dArray2, dArray3, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    public double[] getVals(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                dArray[n] = Double.valueOf(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                dArray[n] = Double.NEGATIVE_INFINITY;
            }
            ++n;
        }
        return dArray;
    }

    protected void getXAxisLabels(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(delimiter, n + 1);
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n = 0;
        while (n < n2 - 1) {
            int n4 = string.indexOf(delimiter, n3);
            stringArray[n] = string.substring(n3, n4);
            n3 = n4 + 1;
            ++n;
        }
        stringArray[n] = string.substring(n3);
        this.chart.getXAxis().addLabels(stringArray);
    }

    public Image makeURLImage(String string) {
        return this.getter.makeURLImage(string);
    }

    public InputStream openURL(String string) {
        return this.getter.openURL(string);
    }

    public void parseAxOptions(String string, AxisInterface axisInterface) {
        if (axisInterface == null) {
            return;
        }
        String string2 = this.getParameter(String.valueOf(string) + "Options");
        if (string2 != null) {
            this.getAxisOptions(axisInterface, string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Start")) != null) {
            axisInterface.setAxisStart(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "End")) != null) {
            axisInterface.setAxisEnd(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFont")) != null) {
            axisInterface.setLabelFont(ParameterParser.getFont(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelAngle")) != null) {
            axisInterface.setLabelAngle(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelPrecision")) != null) {
            axisInterface.setLabelPrecision(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFormat")) != null) {
            axisInterface.setLabelFormat(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Color")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelColor")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LineColor")) != null) {
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridColor")) != null) {
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickColor")) != null) {
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickLength")) != null) {
            axisInterface.setMajTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickLength")) != null) {
            axisInterface.setMinTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickCount")) != null) {
            axisInterface.setNumMajTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickCount")) != null) {
            axisInterface.setNumMinTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridCount")) != null) {
            axisInterface.setNumGrids(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelCount")) != null) {
            axisInterface.setNumLabels(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Title")) != null) {
            axisInterface.setTitleString(string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleColor")) != null) {
            axisInterface.setTitleColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleFont")) != null) {
            axisInterface.setTitleFont(ParameterParser.getFont(string2));
        }
    }

    public void replaceDataLabels(int n, String[] stringArray) {
        Vector vector = this.chart.getDatasets()[n].getData();
        int n2 = 0;
        while (n2 < vector.size()) {
            Datum datum = (Datum)vector.elementAt(n2);
            try {
                datum.setLabel(stringArray[n2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n2;
        }
    }

    protected void reReadURLDatasets() {
        int n;
        int n2;
        int n3;
        double[] dArray;
        Object object;
        double[] dArray2;
        String string;
        int n4;
        InputStream inputStream;
        String string2 = this.getParameter("customDatasetHandler");
        if (string2 != null) {
            this.getter.getMyDatasets(string2);
        }
        if ((string2 = this.getParameter("URLDataBlock")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataRows")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    object = this.getVals(string);
                    dArray = new double[((double[])object).length / 2];
                    dArray2 = new double[dArray.length];
                    n3 = 0;
                    n2 = 0;
                    while (n2 < ((double[])object).length) {
                        try {
                            dArray[n3] = object[n2];
                            dArray2[n3] = object[++n2];
                            ++n3;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.out.println("need same number of x & y observations in dataset " + n4);
                            return;
                        }
                        ++n2;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataColumns")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                n2 = Integer.parseInt(string.trim());
                n3 = this.chart.getNumDatasets() * 2;
                object = new double[n2][];
                dArray = new double[n2];
                dArray2 = new double[n2];
                n4 = 0;
                while (n4 < n2) {
                    string = this.getLineFromURL(inputStream);
                    object[n4] = (double)this.getVals(string);
                    ++n4;
                }
            } else {
                return;
            }
            this.closeURL(inputStream);
            n4 = 0;
            while (n4 < n3) {
                n = 0;
                while (n < n2) {
                    try {
                        dArray[n] = object[n][n4];
                        dArray2[n] = object[n][n4 + 1];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("need same number of x & y observations in column " + n4 + " and row " + n);
                        return;
                    }
                    ++n;
                }
                this.chart.getDatasets()[n4 / 2].replaceYData(dArray2);
                this.chart.getDatasets()[n4 / 2].replaceXData(dArray);
                n4 += 2;
            }
        }
        n4 = 0;
        while (n4 < this.chart.getNumDatasets()) {
            string2 = this.getParameter("dataset" + n4 + "xURL");
            if (string2 != null) {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                }
                this.closeURL(inputStream);
            }
            if ((string2 = this.getParameter("dataset" + n4 + "yURL")) != null) {
                if (string2.equalsIgnoreCase("fake")) {
                    dArray2 = new double[5];
                    n = 0;
                    while (n < 5) {
                        dArray2[n] = 10.0 * Math.random();
                        ++n;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                } else {
                    inputStream = this.openURL(string2);
                    if (inputStream != null) {
                        string = this.getLineFromURL(inputStream);
                        dArray2 = this.getVals(string);
                        this.chart.getDatasets()[n4].replaceYData(dArray2);
                        this.closeURL(inputStream);
                    }
                }
            }
            if ((string2 = this.getParameter("dataset" + n4 + "URLLabels")) != null && (inputStream = this.openURL(string2)) != null) {
                string = this.getLineFromURL(inputStream);
                String[] stringArray = this.getLabels(string);
                this.replaceDataLabels(n4, stringArray);
                this.closeURL(inputStream);
            }
            ++n4;
        }
    }

    public static void setLocale(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("canada")) {
            Locale.setDefault(Locale.CANADA);
        } else if (string.equalsIgnoreCase("canada_french")) {
            Locale.setDefault(Locale.CANADA_FRENCH);
        } else if (string.equalsIgnoreCase("china")) {
            Locale.setDefault(Locale.CHINA);
        } else if (string.equalsIgnoreCase("chinese")) {
            Locale.setDefault(Locale.CHINESE);
        } else if (string.equalsIgnoreCase("english")) {
            Locale.setDefault(Locale.ENGLISH);
        } else if (string.equalsIgnoreCase("france")) {
            Locale.setDefault(Locale.FRANCE);
        } else if (string.equalsIgnoreCase("french")) {
            Locale.setDefault(Locale.FRENCH);
        } else if (string.equalsIgnoreCase("german")) {
            Locale.setDefault(Locale.GERMAN);
        } else if (string.equalsIgnoreCase("germany")) {
            Locale.setDefault(Locale.GERMANY);
        } else if (string.equalsIgnoreCase("italian")) {
            Locale.setDefault(Locale.ITALIAN);
        } else if (string.equalsIgnoreCase("italy")) {
            Locale.setDefault(Locale.ITALY);
        } else if (string.equalsIgnoreCase("japan")) {
            Locale.setDefault(Locale.JAPAN);
        } else if (string.equalsIgnoreCase("japanese")) {
            Locale.setDefault(Locale.JAPANESE);
        } else if (string.equalsIgnoreCase("korea")) {
            Locale.setDefault(Locale.KOREA);
        } else if (string.equalsIgnoreCase("korean")) {
            Locale.setDefault(Locale.KOREAN);
        } else if (string.equalsIgnoreCase("PRC")) {
            Locale.setDefault(Locale.PRC);
        } else if (string.equalsIgnoreCase("simplified_chinese")) {
            Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
        } else if (string.equalsIgnoreCase("taiwan")) {
            Locale.setDefault(Locale.TAIWAN);
        } else if (string.equalsIgnoreCase("traditional_chinese")) {
            Locale.setDefault(Locale.TRADITIONAL_CHINESE);
        } else if (string.equalsIgnoreCase("UK")) {
            Locale.setDefault(Locale.UK);
        } else if (string.equalsIgnoreCase("US")) {
            Locale.setDefault(Locale.US);
        }
    }
}

