/*
 * Decompiled with CFR 0.152.
 */
package javachart.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.applet.GetParam;
import javachart.applet.MessageFrame;
import javachart.applet.ParameterParser;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;

public abstract class ChartAppShell
extends Applet
implements Runnable,
GetParam {
    protected boolean home = true;
    public ChartInterface chart;
    public ParameterParser parser;
    protected Thread getThread;
    protected int networkInterval = -1;
    protected MediaTracker imageTracker;
    protected boolean gotImages;
    static MessageFrame messageFrame;
    protected boolean useDwellLabel = true;
    protected NumberFormat dwellLabelFormat = null;
    protected boolean dwellUseXValue = true;
    protected boolean dwellUseYValue = true;
    protected boolean dwellUseString = false;
    protected String dwellXString;
    protected String dwellYString;
    private int secondsSoFar = 0;
    protected Vector displayList = new Vector();
    protected boolean showDataPopup = false;
    protected boolean dwellLabelVisible = false;
    protected int popupX = 0;
    protected int popupY = 0;
    protected String dwellLabelXString;
    protected String dwellLabelYString;
    protected String dwellLabelLabelString;
    protected Vector links;
    protected String target = "_blank";

    public boolean closeURL(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("can't close URL");
            return false;
        }
        return true;
    }

    public void destroy() {
        this.stop();
        this.chart.setImage(null);
        this.chart = null;
        if (messageFrame != null) {
            messageFrame.dispose();
        }
    }

    protected void displayInfo(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Datum) {
                this.dwellLabelXString = this.getDwellLabelXString((Datum)e);
                this.dwellLabelYString = this.getDwellLabelYString((Datum)e);
                this.dwellLabelLabelString = this.getDwellLabelLabelString((Datum)e);
                this.showDataPopup = true;
                this.repaint();
                return;
            }
            ++n;
        }
    }

    protected void doDwellLabel() {
        if (this.dwellLabelVisible || !this.useDwellLabel) {
            return;
        }
        Point point = new Point(this.popupX, this.popupY);
        this.displayList.removeAllElements();
        if (this.chart.getDisplayList().contains(point, this.displayList)) {
            this.displayInfo(this.displayList);
        }
    }

    void doVEMessage() {
        if (messageFrame == null) {
            messageFrame = new MessageFrame();
            messageFrame.setAppletContext(this.getAppletContext());
        }
        ((Component)messageFrame).setVisible(true);
    }

    protected void drawDataPopup(Graphics graphics) {
        int n;
        int n2;
        int n3;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = 0;
        StringTokenizer stringTokenizer = null;
        int n5 = 0;
        if (this.dwellLabelLabelString != null && this.dwellUseString) {
            if (this.dwellLabelLabelString.indexOf("|") == -1) {
                n4 = fontMetrics.stringWidth(this.dwellLabelLabelString) + 6;
                n5 = 1;
            } else {
                n3 = 0;
                n2 = 0;
                stringTokenizer = new StringTokenizer(this.dwellLabelLabelString, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    n2 = fontMetrics.stringWidth(stringTokenizer.nextToken());
                    if (n2 > n3) {
                        n3 = n2;
                    }
                    ++n5;
                }
                n4 = n3 + 6;
            }
        }
        if ((n2 = this.dwellUseYValue ? fontMetrics.stringWidth(this.dwellLabelYString) + 6 : 0) > (n = n4 > (n3 = this.dwellUseXValue ? fontMetrics.stringWidth(this.dwellLabelXString) + 6 : 0) ? n4 : n3)) {
            n = n2;
        }
        int n6 = fontMetrics.getHeight() + 4;
        int n7 = 4;
        if (this.dwellUseXValue) {
            n7 += n6;
        }
        if (this.dwellUseYValue) {
            n7 += n6;
        }
        if (this.dwellUseString) {
            n7 += n5 * n6;
        }
        if (this.popupX + n > this.getSize().width) {
            this.popupX = this.getSize().width - n - 10;
        }
        this.popupY -= n7;
        if (this.popupY < 0) {
            this.popupY = 0;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(this.popupX, this.popupY, n, n7);
        graphics.setColor(Color.black);
        graphics.drawRect(this.popupX, this.popupY, n, n7);
        graphics.drawLine(this.popupX + 1, this.popupY + n7 + 1, this.popupX + 1 + n, this.popupY + 1 + n7);
        graphics.drawLine(this.popupX + n + 1, this.popupY + 1, this.popupX + 1 + n, this.popupY + 1 + n7);
        int n8 = n6;
        if (this.dwellUseString && this.dwellLabelLabelString != null) {
            if (stringTokenizer == null) {
                graphics.drawString(this.dwellLabelLabelString, this.popupX + 3, this.popupY + n8);
                n8 += n6;
            } else {
                StringTokenizer stringTokenizer2 = new StringTokenizer(this.dwellLabelLabelString, "|");
                while (stringTokenizer2.hasMoreTokens()) {
                    graphics.drawString(stringTokenizer2.nextToken(), this.popupX + 3, this.popupY + n8);
                    n8 += n6;
                }
            }
        }
        if (this.dwellUseXValue) {
            graphics.drawString(this.dwellLabelXString, this.popupX + 3, this.popupY + n8);
            n8 += n6;
        }
        if (this.dwellUseYValue) {
            graphics.drawString(this.dwellLabelYString, this.popupX + 3, this.popupY + n8);
        }
        this.popupY += n7;
    }

    public void drawMyStuff(Graphics graphics) {
        if (this.home) {
            return;
        }
        graphics.setColor(Color.blue);
        graphics.fillRect(this.getSize().width - 20, this.getSize().height - 20, 5, 5);
    }

    public Dataset getDataset(ChartInterface chartInterface, int n) {
        return null;
    }

    protected int getDatasetIndex(Dataset dataset) {
        Dataset[] datasetArray = this.chart.getDatasets();
        int n = 0;
        while (n < datasetArray.length) {
            if (dataset == datasetArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void getDatasetLinks(int n) {
        String string = this.getParameter("dataset" + n + "Links");
        if (string != null) {
            this.chart.setUseDisplayList(true);
            if (this.links == null) {
                this.links = new Vector();
            }
            String[] stringArray = this.parser.getLabels(string);
            this.links.addElement(stringArray);
        }
        if ((string = this.getParameter("target")) != null) {
            this.target = string;
        }
    }

    protected int getDatumIndex(Datum datum, int n) {
        if (n == -1) {
            return -1;
        }
        Vector vector = this.chart.getDatasets()[n].getData();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == datum) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected String getDwellLabelLabelString(Datum datum) {
        String string = datum.getLabel();
        return string;
    }

    protected String getDwellLabelXString(Datum datum) {
        if (!(this.dwellLabelFormat instanceof NumberFormat)) {
            return this.dwellLabelFormat.format(new Double(datum.getX()));
        }
        String string = this.dwellLabelFormat.format(datum.getX());
        int n = this.dwellXString.indexOf("#");
        return this.dwellXString.substring(0, n) + string + this.dwellXString.substring(n + 1);
    }

    protected String getDwellLabelYString(Datum datum) {
        if (!(this.dwellLabelFormat instanceof NumberFormat)) {
            return this.dwellLabelFormat.format(new Double(datum.getY()));
        }
        String string = this.dwellLabelFormat.format(datum.getY());
        int n = this.dwellYString.indexOf("#");
        return this.dwellYString.substring(0, n) + string + this.dwellYString.substring(n + 1);
    }

    public void getMyDatasets(String string) {
    }

    public void getMyOptions() {
    }

    protected void getOptions() {
        String string;
        this.installMouseAdapter();
        if (this.parser == null) {
            this.parser = new ParameterParser(this.chart, this);
        }
        if (this.getCodeBase().getHost().equals("www.ve.com")) {
            this.home = true;
        } else {
            string = this.getParameter("CopyrightNotification");
            if (string != null) {
                if (string.equals("KavaChart is a copyrighted work, and subject to full legal protection")) {
                    this.home = true;
                } else if (string.equals("JavaChart is a copyrighted work, and subject to full legal protection")) {
                    this.home = true;
                }
            }
        }
        string = this.getParameter("networkInterval");
        if (string != null) {
            this.networkInterval = Integer.parseInt(string);
        }
        if ((string = this.getParameter("dwellLabelsOn")) != null && string.equalsIgnoreCase("false")) {
            this.useDwellLabel = false;
        }
        if ((string = this.getParameter("dwellUseLabelString")) != null && string.equalsIgnoreCase("true")) {
            this.dwellUseString = true;
        }
        if ((string = this.getParameter("dwellUseXValue")) != null && string.equalsIgnoreCase("false")) {
            this.dwellUseXValue = false;
        }
        if ((string = this.getParameter("dwellUseYValue")) != null && string.equalsIgnoreCase("false")) {
            this.dwellUseYValue = false;
        }
        this.dwellXString = (string = this.getParameter("dwellXString")) != null ? string : "X: #";
        string = this.getParameter("dwellYString");
        this.dwellYString = string != null ? string : "Y: #";
        this.parser.getOptions();
        this.getMyOptions();
        if (this.dwellLabelFormat == null) {
            this.dwellLabelFormat = NumberFormat.getInstance();
        }
        if ((string = this.getParameter("dwellLabelPrecision")) != null) {
            this.dwellLabelFormat.setMaximumFractionDigits(Integer.parseInt(string));
            this.dwellLabelFormat.setMinimumFractionDigits(Integer.parseInt(string));
        }
        int n = 0;
        while (n < 40) {
            this.getDatasetLinks(n);
            ++n;
        }
    }

    public void handlePick(Point point) {
        int n = 0;
        int n2 = -1;
        if (this.links == null) {
            return;
        }
        Point point2 = new Point(point.x, point.y);
        Vector vector = new Vector();
        if (this.chart.getDisplayList().contains(point2, vector)) {
            int n3 = 0;
            while (n3 < vector.size()) {
                Object e = vector.elementAt(n3);
                if (e instanceof Dataset) {
                    n = this.getDatasetIndex((Dataset)e);
                }
                if (e instanceof Datum) {
                    n2 = this.getDatumIndex((Datum)e, n);
                }
                ++n3;
            }
            if (n == -1 || n2 == -1) {
                return;
            }
            this.openLink(n, n2);
        }
    }

    protected void initLocale() {
        String string = this.getParameter("defaultFont");
        if (string != null) {
            Gc.defaultFont = ParameterParser.getFont(string);
        }
        ParameterParser.setLocale(this.getParameter("locale"));
    }

    protected void installMouseAdapter() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ChartAppShell.this.home) {
                    ChartAppShell.this.doVEMessage();
                }
                ChartAppShell.this.handlePick(new Point(mouseEvent.getX(), mouseEvent.getY()));
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (ChartAppShell.this.showDataPopup) {
                    if (Math.abs(mouseEvent.getX() - ChartAppShell.this.popupX) > 3 || Math.abs(mouseEvent.getY() - ChartAppShell.this.popupY) > 3) {
                        ChartAppShell.this.showDataPopup = false;
                        ChartAppShell.this.repaint();
                    }
                    return;
                }
                ChartAppShell.this.popupX = mouseEvent.getX();
                ChartAppShell.this.popupY = mouseEvent.getY();
            }
        });
    }

    public Image makeURLImage(String string) {
        Image image = this.getImage(this.getCodeBase(), string);
        if (!this.gotImages) {
            this.imageTracker = new MediaTracker(this);
            this.gotImages = true;
        }
        this.imageTracker.addImage(image, 0);
        return image;
    }

    protected void openLink(int n, int n2) {
        try {
            String[] stringArray = (String[])this.links.elementAt(n);
            String string = stringArray[n2];
            try {
                this.getAppletContext().showDocument(new URL(string), this.target);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    URL uRL = new URL(this.getDocumentBase(), string);
                    this.getAppletContext().showDocument(uRL, this.target);
                }
                catch (MalformedURLException malformedURLException2) {
                    System.out.println("couldn't open " + string);
                    return;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public InputStream openURL(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String string2 = this.getDocumentBase().toExternalForm();
                String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
                uRL = new URL(string3 + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("couldn't open " + string);
                return null;
            }
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println("can't open stream " + string);
            return null;
        }
        return inputStream;
    }

    public void paint(Graphics graphics) {
        if (this.gotImages) {
            try {
                this.imageTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        try {
            this.chart.paint(this, graphics);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("out of memory, no label rotation or double-buffering");
            this.showStatus("low memory");
            this.chart.setStringRotator(null);
            this.chart.setImage(null);
            this.chart.drawGraph(graphics);
        }
        this.drawMyStuff(graphics);
        if (this.showDataPopup) {
            this.drawDataPopup(graphics);
            this.dwellLabelVisible = true;
        } else {
            this.dwellLabelVisible = false;
        }
    }

    public void print(Graphics graphics) {
        String string = System.getSecurityManager().toString();
        if (string.indexOf("etscape") != -1) {
            System.out.println("correcting for Netscape sizing bug");
            double d = 0.75;
            string = this.getParameter("netscapePrintScaleFactor");
            if (string != null) {
                d = Double.valueOf(string);
            }
            Dimension dimension = new Dimension((int)((double)this.getSize().width * d), (int)((double)this.getSize().height * d));
            this.chart.resize(dimension.width, dimension.height);
            if (this.getParameter("noRotations") != null) {
                this.chart.drawGraph(graphics);
            } else {
                Image image = this.createImage(dimension.width, dimension.height);
                Image image2 = this.chart.getImage();
                this.chart.setImage(image);
                this.chart.drawGraph(image.getGraphics());
                graphics.drawImage(image, 0, 0, null);
                this.chart.setImage(image2);
            }
            this.chart.resize(this.getSize().width, this.getSize().height);
        } else if (this.getParameter("noRotations") != null) {
            this.chart.resize(this.getSize().width, this.getSize().height);
            this.chart.drawGraph(graphics);
        } else {
            graphics.drawImage(this.chart.getImage(), 0, 0, null);
        }
    }

    public void reReadURLDatasets() {
        this.parser.reReadURLDatasets();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    if (this.networkInterval != -1 && this.secondsSoFar > this.networkInterval) {
                        this.secondsSoFar = 0;
                        this.reReadURLDatasets();
                        this.showDataPopup = false;
                        this.repaint();
                        continue;
                    }
                    this.doDwellLabel();
                    ++this.secondsSoFar;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() {
        if (this.useDwellLabel) {
            this.chart.setUseDisplayList(true);
        } else {
            this.chart.setUseDisplayList(false);
        }
        if (this.getThread == null) {
            this.getThread = new Thread(this);
            this.getThread.start();
        }
    }

    public void stop() {
        if (this.getThread != null) {
            this.getThread.stop();
            this.getThread = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

